<?php
// Vérifie si un numéro d'article est fourni dans l'URL
if (isset($_GET['article'])) {
    $articleNumber = $_GET['article']; // Récupère le numéro d'article
    // Construction du chemin vers le fichier article correspondant
    $articleFile = "articles/article" . htmlspecialchars($articleNumber) . ".html";

    // Vérification : Si le fichier existe, on l'utilise. Sinon, on dirige vers _404.html
    if (file_exists($articleFile)) {
        $articleToInclude = $articleFile; // Article valide
    } else {
        $articleToInclude = "template_part/_404.html"; // Page 404
    }
} else {
    // Si aucun numéro n'est fourni, on dirige directement vers _404.html
    $articleToInclude = "template_part/_404.html";
}
?>

<?php include 'template_part/_head.html'; ?> <!-- Inclut la partie <head> -->
<?php include 'template_part/_header.html'; ?> <!-- Inclut le header -->
<?php include $articleToInclude; ?> <!-- Inclut l'article ou la page 404 dynamiquement -->
<?php include 'template_part/_footer.html'; ?> <!-- Inclut le footer -->
