<?php
// Récupération de tous les fichiers dans le répertoire "articles"
$articles = glob("articles/article*.html"); // Trouve tous les fichiers "articleXX.html" 
?>

<?php include 'template_part/_head.html'; ?> <!-- Inclut la partie <head> -->
<?php include 'template_part/_header.html'; ?> <!-- Inclut le header -->


    <h2>Boucle d'article de la HomePage</h2>
    <hr> <!-- Séparateur  -->
    <?php
    // Vérifie si des articles ont été trouvés
    if (!empty($articles)) {
        // Boucle pour afficher le contenu de chaque article
        foreach ($articles as $article) {
            // Extraction du numéro d'article depuis le nom du fichier
            preg_match('/article(\d+)\.html$/', $article, $matches);
            $articleNumber = $matches[1];
            ?>
            <div>
                <?php include $article; ?> <!-- Inclut le contenu de l'article -->
                <a href="single.php?article=<?php echo $articleNumber; ?>">Lire la suite</a>
            </div>
            <hr> <!-- Séparateur entre les articles -->
            <?php
        }
    } else {
        // Message affiché si aucun article n'est trouvé
        echo "<p>Aucun article disponible pour le moment.</p>";
    }
    ?>


<?php include 'template_part/_footer.html'; ?> <!-- Inclut le footer -->